const db = require('./src/config/db');
const bcrypt = require('bcryptjs');

async function seed() {
    try {
        console.log('Seeding database...');

        // 1. Create Admin User
        const password_hash = await bcrypt.hash('123@', 10);
        await db.execute(
            'INSERT IGNORE INTO users (username, email, password_hash, role) VALUES (?, ?, ?, ?)',
            ['admin', 'admin@example.com', password_hash, 'ADMIN']
        );
        console.log('Admin user created (admin / 123@)');

        // 2. Create Sample Customers
        await db.execute(
            'INSERT IGNORE INTO customers (full_name, phone, email, address) VALUES (?, ?, ?, ?)',
            ['John Doe', '1234567890', 'john@example.com', '123 Main St']
        );
        console.log('Sample customer created');

        // 3. Create Sample Items
        const items = [
            ['ITM001', 'Power Drill', '18V Cordless Power Drill', 10.00, 'HOUR'],
            ['ITM002', 'Cement Mixer', 'Electric 140L Cement Mixer', 50.00, 'DAY'],
            ['ITM003', 'Ladder', 'Aluminum 24ft Extension Ladder', 15.00, 'DAY']
        ];

        for (const item of items) {
            await db.execute(
                'INSERT IGNORE INTO items (item_code, item_name, description, rental_rate, rate_type) VALUES (?, ?, ?, ?, ?)',
                item
            );
        }
        console.log('Sample items created');

        console.log('Seeding completed successfully');
        process.exit(0);
    } catch (err) {
        console.error('Seeding failed:', err);
        process.exit(1);
    }
}

seed();
