const authService = require('../services/authService');

class AuthController {
    async register(req, res, next) {
        try {
            const user = await authService.register(req.body);
            res.status(201).json({ success: true, data: user });
        } catch (err) {
            next(err);
        }
    }

    async login(req, res, next) {
        try {
            const { username, password } = req.body;
            const result = await authService.login(username, password);
            res.json({ success: true, ...result });
        } catch (err) {
            next(err);
        }
    }

    async getAll(req, res, next) {
        try {
            const users = await authService.getAllUsers();
            res.json({ success: true, data: users });
        } catch (err) {
            next(err);
        }
    }

    async update(req, res, next) {
        try {
            const user = await authService.updateUser(req.params.id, req.body);
            res.json({ success: true, data: user });
        } catch (err) {
            next(err);
        }
    }

    async delete(req, res, next) {
        try {
            const result = await authService.deleteUser(req.params.id);
            res.json({ success: true, data: result });
        } catch (err) {
            next(err);
        }
    }
}

module.exports = new AuthController();
