const customerService = require('../services/customerService');

class CustomerController {
    async getAll(req, res, next) {
        try {
            const customers = await customerService.getAll();
            res.json({ success: true, data: customers });
        } catch (err) {
            next(err);
        }
    }

    async getById(req, res, next) {
        try {
            const customer = await customerService.getById(req.params.id);
            if (!customer) return res.status(404).json({ message: 'Customer not found' });
            res.json({ success: true, data: customer });
        } catch (err) {
            next(err);
        }
    }

    async create(req, res, next) {
        try {
            const customer = await customerService.create(req.body);
            res.status(201).json({ success: true, data: customer });
        } catch (err) {
            next(err);
        }
    }

    async update(req, res, next) {
        try {
            const customer = await customerService.update(req.params.id, req.body);
            res.json({ success: true, data: customer });
        } catch (err) {
            next(err);
        }
    }

    async delete(req, res, next) {
        try {
            await customerService.delete(req.params.id);
            res.json({ success: true, message: 'Customer deleted' });
        } catch (err) {
            next(err);
        }
    }
}

module.exports = new CustomerController();
