const itemService = require('../services/itemService');

class ItemController {
    async getAll(req, res, next) {
        try {
            const items = await itemService.getAll();
            res.json({ success: true, data: items });
        } catch (err) {
            next(err);
        }
    }

    async getById(req, res, next) {
        try {
            const item = await itemService.getById(req.params.id);
            if (!item) return res.status(404).json({ message: 'Item not found' });
            res.json({ success: true, data: item });
        } catch (err) {
            next(err);
        }
    }

    async create(req, res, next) {
        try {
            const item = await itemService.create(req.body);
            res.status(201).json({ success: true, data: item });
        } catch (err) {
            next(err);
        }
    }

    async update(req, res, next) {
        try {
            const item = await itemService.update(req.params.id, req.body);
            res.json({ success: true, data: item });
        } catch (err) {
            next(err);
        }
    }

    async updateStatus(req, res, next) {
        try {
            const { status } = req.body;
            const result = await itemService.updateStatus(req.params.id, status);
            res.json({ success: true, data: result });
        } catch (err) {
            next(err);
        }
    }
}

module.exports = new ItemController();
