const rentalService = require('../services/rentalService');

class RentalController {
    async getAll(req, res, next) {
        try {
            const rentals = await rentalService.getAll();
            res.json({ success: true, data: rentals });
        } catch (err) {
            next(err);
        }
    }

    async getById(req, res, next) {
        try {
            const rental = await rentalService.getById(req.params.id);
            if (!rental) return res.status(404).json({ message: 'Rental not found' });
            res.json({ success: true, data: rental });
        } catch (err) {
            next(err);
        }
    }

    async start(req, res, next) {
        try {
            const result = await rentalService.startRental(req.body, req.user.id);
            res.status(201).json({ success: true, data: result });
        } catch (err) {
            next(err);
        }
    }

    async return(req, res, next) {
        try {
            const { itemsToReturn, paymentDetails } = req.body;
            const result = await rentalService.returnRental(req.params.id, itemsToReturn, paymentDetails);
            res.json({ success: true, data: result });
        } catch (err) {
            next(err);
        }
    }
}

module.exports = new RentalController();
