const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');
const auth = require('../middleware/auth');

router.post('/register', auth(['ADMIN']), authController.register);
router.post('/login', authController.login);
router.get('/users', auth(['ADMIN']), authController.getAll);
router.put('/users/:id', auth(['ADMIN']), authController.update);
router.delete('/users/:id', auth(['ADMIN']), authController.delete);

module.exports = router;
