const express = require('express');
const router = express.Router();
const itemController = require('../controllers/itemController');
const auth = require('../middleware/auth');

router.get('/', itemController.getAll);
router.get('/:id', itemController.getById);

router.use(auth()); // Require login for create/update

router.post('/', itemController.create);
router.put('/:id', itemController.update);
router.patch('/:id/status', itemController.updateStatus);

module.exports = router;
