const express = require('express');
const router = express.Router();
const rentalController = require('../controllers/rentalController');
const auth = require('../middleware/auth');

router.use(auth());

router.get('/', rentalController.getAll);
router.get('/:id', rentalController.getById);
router.post('/start', rentalController.start);
router.post('/return/:id', rentalController.return);

module.exports = router;
